/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker;

import club.sk1er.mods.core.util.ModCoreDesktop;
import club.sk1er.patcher.asm.BakedQuadTransformer;
import club.sk1er.patcher.asm.BlockBrewingStandTransformer;
import club.sk1er.patcher.asm.BlockCropsTransformer;
import club.sk1er.patcher.asm.BlockNetherWartTransformer;
import club.sk1er.patcher.asm.ChatStyleTransformer;
import club.sk1er.patcher.asm.ChunkCoordIntPairTransformer;
import club.sk1er.patcher.asm.EnchantmentTransformer;
import club.sk1er.patcher.asm.FallbackResourceManagerTransformer;
import club.sk1er.patcher.asm.GuiIngameTransformer;
import club.sk1er.patcher.asm.GuiPlayerTabOverlayTransformer;
import club.sk1er.patcher.asm.LongHashMapTransformer;
import club.sk1er.patcher.asm.TexturedQuadTransformer;
import club.sk1er.patcher.asm.forge.ForgeChunkManagerTransformer;
import club.sk1er.patcher.asm.forge.ModelLoaderTransformer;
import club.sk1er.patcher.tweaker.asm.AbstractResourcePackTransformer;
import club.sk1er.patcher.tweaker.asm.AnvilChunkLoaderTransformer;
import club.sk1er.patcher.tweaker.asm.ArmorStandRendererTransformer;
import club.sk1er.patcher.tweaker.asm.BlockCactusTransformer;
import club.sk1er.patcher.tweaker.asm.BlockFluidRendererTransformer;
import club.sk1er.patcher.tweaker.asm.BlockPistonBaseTransformer;
import club.sk1er.patcher.tweaker.asm.BlockPistonStructureHelperTransformer;
import club.sk1er.patcher.tweaker.asm.BlockPosTransformer;
import club.sk1er.patcher.tweaker.asm.BlockRedstoneTorchTransformer;
import club.sk1er.patcher.tweaker.asm.BlockRendererDispatcherTransformer;
import club.sk1er.patcher.tweaker.asm.C01PacketChatMessageTransformer;
import club.sk1er.patcher.tweaker.asm.C17PacketCustomPayloadTransformer;
import club.sk1er.patcher.tweaker.asm.ChunkRenderDispatcherTransformer;
import club.sk1er.patcher.tweaker.asm.ChunkTransformer;
import club.sk1er.patcher.tweaker.asm.CommandHandlerTransformer;
import club.sk1er.patcher.tweaker.asm.ContainerTransformer;
import club.sk1er.patcher.tweaker.asm.EffectRendererTransformer;
import club.sk1er.patcher.tweaker.asm.EntityFXTransformer;
import club.sk1er.patcher.tweaker.asm.EntityItemTransformer;
import club.sk1er.patcher.tweaker.asm.EntityLivingBaseTransformer;
import club.sk1er.patcher.tweaker.asm.EntityOtherPlayerMPTransformer;
import club.sk1er.patcher.tweaker.asm.EntityPlayerSPTransformer;
import club.sk1er.patcher.tweaker.asm.EntityTransformer;
import club.sk1er.patcher.tweaker.asm.EntityXPOrbTransformer;
import club.sk1er.patcher.tweaker.asm.FontRendererTransformer;
import club.sk1er.patcher.tweaker.asm.GameRulesValueTransformer;
import club.sk1er.patcher.tweaker.asm.GameSettingsTransformer;
import club.sk1er.patcher.tweaker.asm.GuiAchievementTransformer;
import club.sk1er.patcher.tweaker.asm.GuiChatTransformer;
import club.sk1er.patcher.tweaker.asm.GuiContainerTransformer;
import club.sk1er.patcher.tweaker.asm.GuiGameOverTransformer;
import club.sk1er.patcher.tweaker.asm.GuiLanguageTransformer;
import club.sk1er.patcher.tweaker.asm.GuiMultiplayerTransformer;
import club.sk1er.patcher.tweaker.asm.GuiNewChatTransformer;
import club.sk1er.patcher.tweaker.asm.GuiOptionsTransformer;
import club.sk1er.patcher.tweaker.asm.GuiOverlayDebugTransformer;
import club.sk1er.patcher.tweaker.asm.GuiScreenResourcePacksTransformer;
import club.sk1er.patcher.tweaker.asm.GuiScreenTransformer;
import club.sk1er.patcher.tweaker.asm.GuiVideoSettingsTransformer;
import club.sk1er.patcher.tweaker.asm.InventoryEffectRendererTransformer;
import club.sk1er.patcher.tweaker.asm.ItemRendererTransformer;
import club.sk1er.patcher.tweaker.asm.ItemStackTransformer;
import club.sk1er.patcher.tweaker.asm.LayerArmorBaseTransformer;
import club.sk1er.patcher.tweaker.asm.LayerArrowTransformer;
import club.sk1er.patcher.tweaker.asm.LayerCreeperChargeTransformer;
import club.sk1er.patcher.tweaker.asm.LayerCustomHeadTransformer;
import club.sk1er.patcher.tweaker.asm.LayerHeldItemTransformer;
import club.sk1er.patcher.tweaker.asm.LayerSpiderEyesTransformer;
import club.sk1er.patcher.tweaker.asm.LayerWitherAuraTransformer;
import club.sk1er.patcher.tweaker.asm.LazyLoadBaseTransformer;
import club.sk1er.patcher.tweaker.asm.MinecraftServerTransformer;
import club.sk1er.patcher.tweaker.asm.MinecraftTransformer;
import club.sk1er.patcher.tweaker.asm.ModelPlayerTransformer;
import club.sk1er.patcher.tweaker.asm.ModelRendererTransformer;
import club.sk1er.patcher.tweaker.asm.NBTTagCompoundTransformer;
import club.sk1er.patcher.tweaker.asm.NBTTagStringTransformer;
import club.sk1er.patcher.tweaker.asm.NetHandlerPlayClientTransformer;
import club.sk1er.patcher.tweaker.asm.NetHandlerPlayServerTransformer;
import club.sk1er.patcher.tweaker.asm.NodeProcessorTransformer;
import club.sk1er.patcher.tweaker.asm.RenderArrowTransformer;
import club.sk1er.patcher.tweaker.asm.RenderEntityItemTransformer;
import club.sk1er.patcher.tweaker.asm.RenderFireballTransformer;
import club.sk1er.patcher.tweaker.asm.RenderFishTransformer;
import club.sk1er.patcher.tweaker.asm.RenderGlobalTransformer;
import club.sk1er.patcher.tweaker.asm.RenderItemTransformer;
import club.sk1er.patcher.tweaker.asm.RenderPlayerTransformer;
import club.sk1er.patcher.tweaker.asm.RenderSnowballTransformer;
import club.sk1er.patcher.tweaker.asm.RenderXPOrbTransformer;
import club.sk1er.patcher.tweaker.asm.ResourcePackRepositoryTransformer;
import club.sk1er.patcher.tweaker.asm.S0EPacketSpawnObjectTransformer;
import club.sk1er.patcher.tweaker.asm.S14PacketEntityTransformer;
import club.sk1er.patcher.tweaker.asm.S19PacketEntityHeadLookTransformer;
import club.sk1er.patcher.tweaker.asm.S19PacketEntityStatusTransformer;
import club.sk1er.patcher.tweaker.asm.S2EPacketCloseWindowTransformer;
import club.sk1er.patcher.tweaker.asm.S3FPacketCustomPayloadTransformer;
import club.sk1er.patcher.tweaker.asm.ScaledResolutionTransformer;
import club.sk1er.patcher.tweaker.asm.ScoreboardTransformer;
import club.sk1er.patcher.tweaker.asm.ScreenShotHelperTransformer;
import club.sk1er.patcher.tweaker.asm.ServerAddressTransformer;
import club.sk1er.patcher.tweaker.asm.ServerListTransformer;
import club.sk1er.patcher.tweaker.asm.ServerSelectionListTransformer;
import club.sk1er.patcher.tweaker.asm.SoundManagerTransformer;
import club.sk1er.patcher.tweaker.asm.StatBaseTransformer;
import club.sk1er.patcher.tweaker.asm.ThreadDownloadImageDataTransformer;
import club.sk1er.patcher.tweaker.asm.TileEntityEnchantmentTableRendererTransformer;
import club.sk1er.patcher.tweaker.asm.TileEntityEndPortalRendererTransformer;
import club.sk1er.patcher.tweaker.asm.TileEntityPistonRendererTransformer;
import club.sk1er.patcher.tweaker.asm.TileEntityRendererDispatcherTransformer;
import club.sk1er.patcher.tweaker.asm.TileEntitySkullRendererTransformer;
import club.sk1er.patcher.tweaker.asm.VertexFormatTransformer;
import club.sk1er.patcher.tweaker.asm.VisGraphTransformer;
import club.sk1er.patcher.tweaker.asm.WorldClientTransformer;
import club.sk1er.patcher.tweaker.asm.WorldRendererTransformer;
import club.sk1er.patcher.tweaker.asm.WorldServerTransformer;
import club.sk1er.patcher.tweaker.asm.WorldTransformer;
import club.sk1er.patcher.tweaker.asm.forge.BlockInfoTransformer;
import club.sk1er.patcher.tweaker.asm.forge.ClientCommandHandlerTransformer;
import club.sk1er.patcher.tweaker.asm.forge.FMLClientHandlerTransformer;
import club.sk1er.patcher.tweaker.asm.forge.FluidRegistryTransformer;
import club.sk1er.patcher.tweaker.asm.forge.ForgeBlockModelRendererTransformer;
import club.sk1er.patcher.tweaker.asm.forge.ForgeHooksClientTransformer;
import club.sk1er.patcher.tweaker.asm.forge.GuiIngameForgeTransformer;
import club.sk1er.patcher.tweaker.asm.forge.GuiModListTransformer;
import club.sk1er.patcher.tweaker.asm.forge.GuiUtilsTransformer;
import club.sk1er.patcher.tweaker.asm.forge.MinecraftForgeClientTransformer;
import club.sk1er.patcher.tweaker.asm.forge.MinecraftForgeTransformer;
import club.sk1er.patcher.tweaker.asm.forge.ModClassLoaderTransformer;
import club.sk1er.patcher.tweaker.asm.forge.VertexLighterFlatTransformer;
import club.sk1er.patcher.tweaker.asm.lwjgl.KeyboardTransformer;
import club.sk1er.patcher.tweaker.asm.lwjgl.WindowsDisplayTransformer;
import club.sk1er.patcher.tweaker.asm.lwjgl.WindowsKeycodesTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.InventoryPlayerTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.witherfix.EntityWitherTransformer;
import club.sk1er.patcher.tweaker.asm.util.ForcePublicTransformer;
import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class ClassTransformer
implements IClassTransformer {
    public static final boolean outputBytecode = "true".equals(System.getProperty("debugBytecode", "false"));
    public static String optifineVersion = "NONE";
    private final Logger logger = LogManager.getLogger((String)"Patcher - Class Transformer");
    private final Multimap<String, PatcherTransformer> transformerMap = ArrayListMultimap.create();

    public ClassTransformer() {
        try {
            HashSet unsupportedOptiFineVersions;
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader("Config");
            classReader.accept((ClassVisitor)classNode, 1);
            for (FieldNode fieldNode : classNode.fields) {
                if (!fieldNode.name.equals("OF_RELEASE")) continue;
                optifineVersion = (String)fieldNode.value;
                break;
            }
            if ((unsupportedOptiFineVersions = Sets.newHashSet((Object[])new String[]{"I3", "H8", "H7", "H6", "H5"})).contains(optifineVersion)) {
                this.logger.info("User has outdated OptiFine. (version: OptiFine-{})", new Object[]{optifineVersion});
                this.haltForOptifine("OptiFine " + optifineVersion + " has been detected, which is not supported by Patcher and will crash.\nPlease update to a newer version of OptiFine (i7 and above are supported) before trying to launch.");
                return;
            }
        }
        catch (IOException e) {
            this.logger.info("Something went wrong, or the user doesn't have optifine");
        }
        this.registerTransformer(new S2EPacketCloseWindowTransformer());
        this.registerTransformer(new EntityItemTransformer());
        this.registerTransformer(new MinecraftTransformer());
        this.registerTransformer(new GuiGameOverTransformer());
        this.registerTransformer(new EntityLivingBaseTransformer());
        this.registerTransformer(new RenderPlayerTransformer());
        this.registerTransformer(new WorldTransformer());
        this.registerTransformer(new ChunkTransformer());
        this.registerTransformer(new EntityPlayerSPTransformer());
        this.registerTransformer(new GuiUtilsTransformer());
        this.registerTransformer(new ChatStyleTransformer());
        this.registerTransformer(new ScoreboardTransformer());
        this.registerTransformer(new GuiAchievementTransformer());
        this.registerTransformer(new GuiScreenTransformer());
        this.registerTransformer(new ItemRendererTransformer());
        this.registerTransformer(new GuiNewChatTransformer());
        this.registerTransformer(new GuiPlayerTabOverlayTransformer());
        this.registerTransformer(new RenderEntityItemTransformer());
        this.registerTransformer(new AbstractResourcePackTransformer());
        this.registerTransformer(new GuiIngameTransformer());
        this.registerTransformer(new BlockCropsTransformer());
        this.registerTransformer(new BlockNetherWartTransformer());
        this.registerTransformer(new NetHandlerPlayClientTransformer());
        this.registerTransformer(new NBTTagStringTransformer());
        this.registerTransformer(new BlockRendererDispatcherTransformer());
        this.registerTransformer(new GuiVideoSettingsTransformer());
        this.registerTransformer(new WorldRendererTransformer());
        this.registerTransformer(new GameSettingsTransformer());
        this.registerTransformer(new AnvilChunkLoaderTransformer());
        this.registerTransformer(new FallbackResourceManagerTransformer());
        this.registerTransformer(new RenderArrowTransformer());
        this.registerTransformer(new TileEntitySkullRendererTransformer());
        this.registerTransformer(new TileEntityEndPortalRendererTransformer());
        this.registerTransformer(new GuiContainerTransformer());
        this.registerTransformer(new EnchantmentTransformer());
        this.registerTransformer(new MinecraftServerTransformer());
        this.registerTransformer(new FontRendererTransformer());
        this.registerTransformer(new LayerCustomHeadTransformer());
        this.registerTransformer(new NBTTagCompoundTransformer());
        this.registerTransformer(new GuiChatTransformer());
        this.registerTransformer(new C01PacketChatMessageTransformer());
        this.registerTransformer(new LayerArrowTransformer());
        this.registerTransformer(new CommandHandlerTransformer());
        this.registerTransformer(new TileEntityRendererDispatcherTransformer());
        this.registerTransformer(new ResourcePackRepositoryTransformer());
        this.registerTransformer(new ServerListTransformer());
        this.registerTransformer(new S14PacketEntityTransformer());
        this.registerTransformer(new S19PacketEntityHeadLookTransformer());
        this.registerTransformer(new S19PacketEntityStatusTransformer());
        this.registerTransformer(new NodeProcessorTransformer());
        this.registerTransformer(new RenderGlobalTransformer());
        this.registerTransformer(new ScreenShotHelperTransformer());
        this.registerTransformer(new GuiScreenResourcePacksTransformer());
        this.registerTransformer(new TileEntityEnchantmentTableRendererTransformer());
        this.registerTransformer(new EntityTransformer());
        this.registerTransformer(new BlockRedstoneTorchTransformer());
        this.registerTransformer(new RenderItemTransformer());
        this.registerTransformer(new LayerArmorBaseTransformer());
        this.registerTransformer(new GameRulesValueTransformer());
        this.registerTransformer(new EntityOtherPlayerMPTransformer());
        this.registerTransformer(new S0EPacketSpawnObjectTransformer());
        this.registerTransformer(new RenderXPOrbTransformer());
        this.registerTransformer(new EntityXPOrbTransformer());
        this.registerTransformer(new SoundManagerTransformer());
        this.registerTransformer(new VisGraphTransformer());
        this.registerTransformer(new WorldClientTransformer());
        this.registerTransformer(new EntityFXTransformer());
        this.registerTransformer(new LongHashMapTransformer());
        this.registerTransformer(new ChunkCoordIntPairTransformer());
        this.registerTransformer(new BakedQuadTransformer());
        this.registerTransformer(new TexturedQuadTransformer());
        this.registerTransformer(new ModelRendererTransformer());
        this.registerTransformer(new EffectRendererTransformer());
        this.registerTransformer(new BlockPosTransformer());
        this.registerTransformer(new WorldServerTransformer());
        this.registerTransformer(new BlockPistonBaseTransformer());
        this.registerTransformer(new BlockPistonStructureHelperTransformer());
        this.registerTransformer(new GuiMultiplayerTransformer());
        this.registerTransformer(new ServerSelectionListTransformer());
        this.registerTransformer(new GuiOverlayDebugTransformer());
        this.registerTransformer(new VertexFormatTransformer());
        this.registerTransformer(new LayerHeldItemTransformer());
        this.registerTransformer(new StatBaseTransformer());
        this.registerTransformer(new ItemStackTransformer());
        this.registerTransformer(new ModelPlayerTransformer());
        this.registerTransformer(new ServerAddressTransformer());
        this.registerTransformer(new LayerSpiderEyesTransformer());
        this.registerTransformer(new LayerCreeperChargeTransformer());
        this.registerTransformer(new LayerWitherAuraTransformer());
        this.registerTransformer(new GuiLanguageTransformer());
        this.registerTransformer(new TileEntityPistonRendererTransformer());
        this.registerTransformer(new RenderFireballTransformer());
        this.registerTransformer(new RenderFishTransformer());
        this.registerTransformer(new RenderSnowballTransformer());
        this.registerTransformer(new S3FPacketCustomPayloadTransformer());
        this.registerTransformer(new NetHandlerPlayServerTransformer());
        this.registerTransformer(new C17PacketCustomPayloadTransformer());
        this.registerTransformer(new BlockCactusTransformer());
        this.registerTransformer(new BlockBrewingStandTransformer());
        this.registerTransformer(new LazyLoadBaseTransformer());
        this.registerTransformer(new ArmorStandRendererTransformer());
        this.registerTransformer(new BlockFluidRendererTransformer());
        this.registerTransformer(new GuiOptionsTransformer());
        this.registerTransformer(new EntityWitherTransformer());
        this.registerTransformer(new ThreadDownloadImageDataTransformer());
        this.registerTransformer(new ChunkRenderDispatcherTransformer());
        this.registerTransformer(new ContainerTransformer());
        this.registerTransformer(new ScaledResolutionTransformer());
        if (ClassTransformer.isDevelopment()) {
            this.registerTransformer(new InventoryEffectRendererTransformer());
        }
        this.registerTransformer(new ClientCommandHandlerTransformer());
        this.registerTransformer(new FMLClientHandlerTransformer());
        this.registerTransformer(new ForgeHooksClientTransformer());
        this.registerTransformer(new GuiModListTransformer());
        this.registerTransformer(new ModClassLoaderTransformer());
        this.registerTransformer(new ModelLoaderTransformer());
        this.registerTransformer(new ForgeChunkManagerTransformer());
        this.registerTransformer(new FluidRegistryTransformer());
        this.registerTransformer(new GuiIngameForgeTransformer());
        this.registerTransformer(new MinecraftForgeClientTransformer());
        this.registerTransformer(new BlockInfoTransformer());
        this.registerTransformer(new VertexLighterFlatTransformer());
        this.registerTransformer(new ForgeBlockModelRendererTransformer());
        this.registerTransformer(new MinecraftForgeTransformer());
        this.registerTransformer(new InventoryPlayerTransformer());
        this.registerTransformer(new WindowsDisplayTransformer());
        this.registerTransformer(new WindowsKeycodesTransformer());
        this.registerTransformer(new KeyboardTransformer());
        this.registerTransformer(new ForcePublicTransformer());
    }

    public static byte[] createTransformer(String transformedName, byte[] bytes, Multimap<String, PatcherTransformer> transformerMap, Logger logger) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        for (PatcherTransformer transformer : transformers) {
            transformer.transform(classNode, transformedName);
        }
        ClassWriter classWriter = new ClassWriter(2);
        try {
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (Throwable e) {
            logger.error("Exception when transforming {} : {}", new Object[]{transformedName, e.getClass().getSimpleName(), e});
        }
        if (outputBytecode) {
            File bytecodeDirectory = new File("bytecode");
            String transformedClassName = transformedName.contains("$") ? transformedName.replace('$', '.') + ".class" : transformedName + ".class";
            try {
                File bytecodeOutput;
                if (!bytecodeDirectory.exists()) {
                    bytecodeDirectory.mkdirs();
                }
                if (!(bytecodeOutput = new File(bytecodeDirectory, transformedClassName)).exists()) {
                    bytecodeOutput.createNewFile();
                }
                try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
                    os.write(classWriter.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classWriter.toByteArray();
    }

    private void registerTransformer(PatcherTransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        return ClassTransformer.createTransformer(transformedName, bytes, this.transformerMap, this.logger);
    }

    private void haltForOptifine(String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JButton openOptifine = new JButton("Open OptiFine Website");
        openOptifine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    ModCoreDesktop.INSTANCE.browse(new URI("https://optifine.net/downloads/"));
                }
                catch (Exception ex) {
                    JLabel label = new JLabel();
                    label.setText("Failed to open OptiFine website.");
                    label.setAlignmentX(0.5f);
                    label.setAlignmentY(0.5f);
                }
            }
        });
        JButton close = new JButton("Close");
        close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ClassTransformer.this.close();
            }
        });
        Object[] options = new Object[]{openOptifine, close};
        JOptionPane.showOptionDialog(null, message, "Launch Aborted", -1, 0, null, options, options[0]);
        this.close();
    }

    private void close() {
        try {
            Class<?> aClass = Class.forName("java.lang.Shutdown");
            Method exit = aClass.getDeclaredMethod("exit", Integer.TYPE);
            exit.setAccessible(true);
            exit.invoke(null, 0);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isDevelopment() {
        Object o = Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return o != null && (Boolean)o != false;
    }
}

